PROGRAM FlirRead
!
! passin fileName
! passout date/time, xsize, ysize and data
!
! Reads in the FLIR Public Format file
!-----------------------------------------------
!
INTEGER          :: FileStatus
CHARACTER(60)    :: FileName
INTEGER          :: Flag1,Flag2,Flag3,Flag4,Flag5,Flag6
!
! Image Data
!
TYPE TFLIRrecord1
  CHARACTER(32)  :: fpfID
  INTEGER(4)     :: Version
  INTEGER(4)     :: PixelOffset
  INTEGER(2)     :: ImageType              ! 0 = Temperature
                                           ! 2 = Difference Temperature
                                           ! 4 = Object Signal
  INTEGER(2)     :: PixelFormat            ! 2 = Float
  INTEGER(2)     :: xSize
  INTEGER(2)     :: ySize
  INTEGER(4)     :: TrigCount
  INTEGER(4)     :: FrameCount
  INTEGER(4)     :: SpareLong(16)
END TYPE TFLIRrecord1
TYPE (TFLIRrecord1) :: ImageData
!
! Camera Data
!
TYPE TFLIRrecord2
  CHARACTER(32)  :: CameraName
  CHARACTER(32)  :: CameraPartNum
  CHARACTER(32)  :: CameraSerialNum
  REAL(4)        :: CameraMinT             ! Kelvin
  REAL(4)        :: CameraMaxT             ! Kelvin
  CHARACTER(32)  :: LensName
  CHARACTER(32)  :: LensPartNum
  CHARACTER(32)  :: LensSerialNum
  CHARACTER(32)  :: FilterName
  CHARACTER(32)  :: FilterPartNum
  CHARACTER(32)  :: FilterSerialNum
  INTEGER(4)     :: SpareLong(16)
END TYPE TFLIRrecord2
TYPE (TFLIRrecord2) :: CameraData
!
! Object Parameters
!
TYPE TFLIRrecord3                          
  REAL(4)        :: Emissivity             ! 0-1
  REAL(4)        :: ObjectDistance         ! Meters
  REAL(4)        :: AmbientTemperature     ! Kelvin
  REAL(4)        :: AtmosphericTemperature ! Kelvin
  REAL(4)        :: RelativeHumidity       ! 0-1
  REAL(4)        :: CompAtmosphTau
  REAL(4)        :: EstiAtmosphTau
  REAL(4)        :: ReferenceTemperature   ! Kelvin
  REAL(4)        :: ExtOptTemperature      ! Kelvin
  REAL(4)        :: ExtOptTransmission     ! 0-1
  INTEGER(4)     :: SpareLong(16)
END TYPE TFLIRrecord3
TYPE (TFLIRrecord3) :: ObjectParameters
!
! Date and Time
!
TYPE TFLIRrecord4                          
  INTEGER(4)     :: Year
  INTEGER(4)     :: Month
  INTEGER(4)     :: Day
  INTEGER(4)     :: Hour
  INTEGER(4)     :: Minute
  INTEGER(4)     :: Second
  INTEGER(4)     :: Millisecond
  INTEGER(4)     :: SpareLong(16)
END TYPE TFLIRrecord4
TYPE (TFLIRrecord4) :: DateTime
!
! Scaling
!
TYPE TFLIRrecord5                          
  REAL(4)        :: tMinCamera
  REAL(4)        :: tMaxCamera
  REAL(4)        :: tMinCalc
  REAL(4)        :: tMaxCalc
  REAL(4)        :: tMinScale
  REAL(4)        :: tMaxScale
  INTEGER(4)     :: SpareLong(16)
END TYPE TFLIRrecord5
TYPE (TFLIRrecord5) :: Scaling
!
! Data Values
!
REAL, DIMENSION(240,320) :: TData
!
!------------------------------------
!
! Read filename 
!
WRITE(*,*) 'Filename to process?'
READ(*,'(A)') FileName
OPEN (UNIT=1,FILE=TRIM(FileName),FORM='unformatted',ACCESS='transparent',STATUS='old',ACTION='read',IOSTAT=FileStatus)
IF (FileStatus /= 0) THEN
  WRITE (*,*) 'File not found!'
  STOP
END IF
!
! Read output options
!
WRITE(*,*) 'Output image information? [0=no,1=yes]'
READ(*,*) Flag1
WRITE(*,*) 'Output camera data? [0=no,1=yes]'
READ(*,*) Flag2
WRITE(*,*) 'Output object parameters? [0=no,1=yes]'
READ(*,*) Flag3
WRITE(*,*) 'Output date and time? [0=no,1=yes]'
READ(*,*) Flag4
WRITE(*,*) 'Output scaling data? [0=no,1=yes]'
READ(*,*) Flag5
WRITE(*,*) 'Output image data? [0=no,1=yes]'
READ(*,*) Flag6
WRITE(*,*) 
!
! Read data
!
READ(1) ImageData
READ(1) CameraData
READ(1) ObjectParameters
READ(1) DateTime
READ(1) Scaling
READ(1) TData
CLOSE (UNIT=1,STATUS='KEEP')
!
! Write data
!
IF (Flag1==1) THEN
  WRITE(*,*) 'Image Information'
  WRITE(*,*) TRIM(ImageData%fpfID)
  WRITE(*,*) 'Version', ImageData%Version
  WRITE(*,*) 'Pixel Offset', ImageData%PixelOffset
  WRITE(*,*) 'Image Type', ImageData%ImageType
  WRITE(*,*) 'Pixel Format', ImageData%PixelFormat
  WRITE(*,*) 'x Size', ImageData%xSize
  WRITE(*,*) 'y Size', ImageData%ySize
  WRITE(*,*) 'Trigger Count', ImageData%TrigCount
  WRITE(*,*) 'Frame Count', ImageData%FrameCount
  WRITE(*,*)
END IF

IF (Flag2==1) THEN
  WRITE (*,*) 'Camera Data'
  WRITE(*,*) 'Camera Name', CameraData%CameraName
  WRITE(*,*) 'Camera Part Number', CameraData%CameraPartNum
  WRITE(*,*) 'Camera Serial Number', CameraData%CameraSerialNum
  WRITE(*,*) 'Camera Min T [K]', CameraData%CameraMinT
  WRITE(*,*) 'Camera Max T [K]', CameraData%CameraMaxT
  WRITE(*,*) 'Lens Name', CameraData%LensName
  WRITE(*,*) 'Lens Part Number', CameraData%LensPartNum
  WRITE(*,*) 'Lens Serial Number', CameraData%LensSerialNum
  WRITE(*,*) 'Filter Name', CameraData%FilterName
  WRITE(*,*) 'Filter Part Number', CameraData%FilterPartNum
  WRITE(*,*) 'Filter Serial Number', CameraData%FilterSerialNum
  WRITE(*,*)
END IF

IF (Flag3==1) THEN
  WRITE(*,*) 'Object Parameters'
  WRITE(*,*) 'Emissivity', ObjectParameters%Emissivity    
  WRITE(*,*) 'Object Distance', ObjectParameters%ObjectDistance
  WRITE(*,*) 'Ambient Temperature [K}', ObjectParameters%AmbientTemperature    
  WRITE(*,*) 'Atmospheric Temperature [K]', ObjectParameters%AtmosphericTemperature
  WRITE(*,*) 'Relative Humidity', ObjectParameters%RelativeHumidity      
  WRITE(*,*) 'Computed Atmospheric Tramsmission', ObjectParameters%CompAtmosphTau
  WRITE(*,*) 'Estimated Atmospheric Transmission', ObjectParameters%EstiAtmosphTau
  WRITE(*,*) 'Reference Temperature [K]', ObjectParameters%ReferenceTemperature  
  WRITE(*,*) 'External Optical Temperature [k]', ObjectParameters%ExtOptTemperature     
  WRITE(*,*) 'External Optical Transmission', ObjectParameters%ExtOptTransmission    
  WRITE(*,*)
END IF

IF (Flag4==1) THEN
  WRITE(*,*) 'Date and Time'
  WRITE(*,*) 'Year', DateTime%Year
  WRITE(*,*) 'Month', DateTime%Month
  WRITE(*,*) 'Day', DateTime%Day
  WRITE(*,*) 'Hour', DateTime%Hour
  WRITE(*,*) 'Minute', DateTime%Minute
  WRITE(*,*) 'Second', DateTime%Second
  WRITE(*,*) 'Millisecond', DateTime%Millisecond
  WRITE(*,*)
END IF

IF (Flag5==1) THEN
  WRITE(*,*) 'Scaling Data'
  WRITE(*,*) 'Camera Scale Minimum [K]', Scaling%tMinCamera
  WRITE(*,*) 'Camera Scale Maximum [K]', Scaling%tMaxCamera
  WRITE(*,*) 'Calculated Minimun [K]', Scaling%tMinCalc
  WRITE(*,*) 'Calculated Maximum [K]', Scaling%tMaxCalc
  WRITE(*,*) 'Scale Minimum', Scaling%tMinScale
  WRITE(*,*) 'Scale Maximum', Scaling%tMaxScale
  WRITE(*,*)
END IF

IF (Flag6==1) THEN
  WRITE(*,*) 'Image Data'
  WRITE(*,*) TData
END IF

END PROGRAM FlirRead

